/*
* cmd_eye.c- Sigmastar
*
* Copyright (C) 2018 Sigmastar Technology Corp.
*
* Author: karl.xiao <karl.xiao@sigmastar.com.tw>
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
*/


#include <common.h>
#include <command.h>
#include "asm/arch/mach/ms_types.h"
#include "asm/arch/mach/platform.h"
#include "asm/arch/mach/io.h"

#define GET_REG8_ADDRE( y)  	      (MS_BASE_REG_RIU_PA+(y)*2-((y)&1))


void USB20_verification_pattern_TSTPG_FS(void)
{
    printf("%s\n",__FUNCTION__);

    OUTREG8(GET_REG8_ADDRE(0x00103380), 0x34);
    OUTREG8(GET_REG8_ADDRE(0x00103381), 0x12);
    OUTREG8(GET_REG8_ADDRE(0x00101ed2), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00101ed3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00113700), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00113702), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00113720), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00113722), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00113740), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00113742), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010c00), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00010c02), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00100800), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00100801), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00100840), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00100841), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00100880), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00100881), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00010a00), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00010a01), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00100804), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00100805), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00100844), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00100845), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00100884), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00100885), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010a04), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00010a05), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142188), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142189), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00142108), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142109), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00142988), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142989), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00142908), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142909), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00103888), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00103889), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00010b08), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00010b09), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x001012fe), 0xe1);
    OUTREG8(GET_REG8_ADDRE(0x001012ff), 0x08);
    OUTREG8(GET_REG8_ADDRE(0x00142188), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142189), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x001421a0), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x001421a1), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x001421a2), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x001421a3), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x001421d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001421d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142182), 0x84);
    OUTREG8(GET_REG8_ADDRE(0x00142183), 0x90);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x02);
    OUTREG8(GET_REG8_ADDRE(0x001421d2), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142108), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142109), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142120), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x00142121), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x00142122), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x00142123), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00142152), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00142153), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142102), 0x84);
    OUTREG8(GET_REG8_ADDRE(0x00142103), 0x90);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x02);
    OUTREG8(GET_REG8_ADDRE(0x00142152), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142153), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142988), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142989), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x001429a0), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x001429a1), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x001429a2), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x001429a3), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x001429d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001429d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142982), 0x84);
    OUTREG8(GET_REG8_ADDRE(0x00142983), 0x90);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x02);
    OUTREG8(GET_REG8_ADDRE(0x001429d2), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142908), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142909), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142920), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x00142921), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x00142922), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x00142923), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00142952), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00142953), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142902), 0x84);
    OUTREG8(GET_REG8_ADDRE(0x00142903), 0x90);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x02);
    OUTREG8(GET_REG8_ADDRE(0x00142952), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142953), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103888), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00103889), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x001038a0), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x001038a1), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x001038a2), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x001038a3), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x001038d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001038d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103882), 0x84);
    OUTREG8(GET_REG8_ADDRE(0x00103883), 0x90);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x02);
    OUTREG8(GET_REG8_ADDRE(0x001038d2), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b08), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00010b09), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00010b20), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x00010b21), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x00010b22), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x00010b23), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00010b52), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00010b53), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b02), 0x84);
    OUTREG8(GET_REG8_ADDRE(0x00010b03), 0x90);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x02);
    OUTREG8(GET_REG8_ADDRE(0x00010b52), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b53), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x00);
    mdelay(1);
    OUTREG8(GET_REG8_ADDRE(0x001421bc), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x001421bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421bc), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014213c), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x0014213d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014213c), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014213d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429bc), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x001429bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429bc), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014293c), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x0014293d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014293c), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014293d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038bc), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x001038bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038bc), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b3c), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010b3d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b3c), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b3d), 0x00);
    mdelay(5);
    OUTREG8(GET_REG8_ADDRE(0x00142190), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142191), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142186), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142187), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142186), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142187), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0xeb);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001421d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142194), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142195), 0x07);
    OUTREG8(GET_REG8_ADDRE(0x001421b4), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421b5), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421b2), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x001421b3), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00142110), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142111), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142106), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142107), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142106), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142107), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0xeb);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142152), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00142153), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142114), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142115), 0x07);
    OUTREG8(GET_REG8_ADDRE(0x00142134), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142135), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142132), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x00142133), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00142990), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142991), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142986), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142987), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142986), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142987), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0xeb);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001429d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142994), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142995), 0x07);
    OUTREG8(GET_REG8_ADDRE(0x001429b4), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429b5), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429b2), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x001429b3), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00142910), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142911), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142906), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142907), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142906), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142907), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0xeb);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142952), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00142953), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142914), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142915), 0x07);
    OUTREG8(GET_REG8_ADDRE(0x00142934), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142935), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142932), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x00142933), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00103890), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00103891), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103886), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00103887), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103886), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00103887), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0xeb);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001038d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103894), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00103895), 0x07);
    OUTREG8(GET_REG8_ADDRE(0x001038b4), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038b5), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038b2), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x001038b3), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00010b10), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00010b11), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b06), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00010b07), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b06), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00010b07), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0xeb);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b52), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00010b53), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b14), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00010b15), 0x07);
    OUTREG8(GET_REG8_ADDRE(0x00010b34), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b35), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b32), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x00010b33), 0x0b);

}
void USB20_verification_pattern_TSTPG(void)
{
    printf("%s\n",__FUNCTION__);
    OUTREG8(GET_REG8_ADDRE(0x00103380), 0x34);
    OUTREG8(GET_REG8_ADDRE(0x00103381), 0x12);
    OUTREG8(GET_REG8_ADDRE(0x00101ed2), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00101ed3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00113700), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00113702), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00113720), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00113722), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00113740), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00113742), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010c00), 0xff);
    OUTREG8(GET_REG8_ADDRE(0x00010c02), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142000), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00142001), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00142040), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00142041), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00142080), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00142081), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00010a00), 0xb0);
    OUTREG8(GET_REG8_ADDRE(0x00010a01), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00142004), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00142005), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142044), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00142045), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142084), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00142085), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010a04), 0x10);
    OUTREG8(GET_REG8_ADDRE(0x00010a05), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142188), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142189), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00142108), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142109), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00142988), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142989), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00142908), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142909), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00103888), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00103889), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x00010b08), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00010b09), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x05);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x7f);
    OUTREG8(GET_REG8_ADDRE(0x001012fe), 0xe1);
    OUTREG8(GET_REG8_ADDRE(0x001012ff), 0x08);
    OUTREG8(GET_REG8_ADDRE(0x00142188), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142189), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x001421a0), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x001421a1), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x001421a2), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x001421a3), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x03);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x6b);
    OUTREG8(GET_REG8_ADDRE(0x001421d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001421d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142108), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142109), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142120), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x00142121), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x00142122), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x00142123), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x03);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x6b);
    OUTREG8(GET_REG8_ADDRE(0x00142152), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00142153), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142988), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142989), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x001429a0), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x001429a1), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x001429a2), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x001429a3), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x03);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x6b);
    OUTREG8(GET_REG8_ADDRE(0x001429d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001429d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142908), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00142909), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00142920), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x00142921), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x00142922), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x00142923), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x03);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x6b);
    OUTREG8(GET_REG8_ADDRE(0x00142952), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00142953), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103888), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00103889), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x001038a0), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x001038a1), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x001038a2), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x001038a3), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x03);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x6b);
    OUTREG8(GET_REG8_ADDRE(0x001038d2), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x001038d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b08), 0x0f);
    OUTREG8(GET_REG8_ADDRE(0x00010b09), 0x04);
    OUTREG8(GET_REG8_ADDRE(0x00010b20), 0xa1);
    OUTREG8(GET_REG8_ADDRE(0x00010b21), 0x80);
    OUTREG8(GET_REG8_ADDRE(0x00010b22), 0x88);
    OUTREG8(GET_REG8_ADDRE(0x00010b23), 0x20);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x03);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x6b);
    OUTREG8(GET_REG8_ADDRE(0x00010b52), 0x3f);
    OUTREG8(GET_REG8_ADDRE(0x00010b53), 0x00);
    mdelay(1);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x69);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0xc3);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x69);
    mdelay(2);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421d2), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421bc), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x001421bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421bc), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142152), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142153), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014213c), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x0014213d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014213c), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014213d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429d2), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429bc), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x001429bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429bc), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142952), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142953), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014293c), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x0014293d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014293c), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x0014293d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038d2), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038d3), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038bc), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x001038bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038bc), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038bd), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b52), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b53), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b3c), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010b3d), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b3c), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b3d), 0x00);
    mdelay(2);
    OUTREG8(GET_REG8_ADDRE(0x00142190), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142191), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142186), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142187), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142186), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142187), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142180), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142181), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142194), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142195), 0x06);
    OUTREG8(GET_REG8_ADDRE(0x001421b4), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421b5), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001421b2), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x001421b3), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00142110), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142111), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142106), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142107), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142106), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142107), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142100), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142101), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142114), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142115), 0x06);
    OUTREG8(GET_REG8_ADDRE(0x00142134), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142135), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142132), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x00142133), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00142990), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142991), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142986), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142987), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142986), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142987), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142980), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142981), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142994), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142995), 0x06);
    OUTREG8(GET_REG8_ADDRE(0x001429b4), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429b5), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001429b2), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x001429b3), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00142910), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00142911), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142906), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00142907), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142906), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00142907), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142900), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00142901), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142914), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142915), 0x06);
    OUTREG8(GET_REG8_ADDRE(0x00142934), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142935), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00142932), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x00142933), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00103890), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00103891), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103886), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00103887), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103886), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00103887), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103880), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00103881), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103894), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00103895), 0x06);
    OUTREG8(GET_REG8_ADDRE(0x001038b4), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038b5), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x001038b2), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x001038b3), 0x0b);
    OUTREG8(GET_REG8_ADDRE(0x00010b10), 0x78);
    OUTREG8(GET_REG8_ADDRE(0x00010b11), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b06), 0x43);
    OUTREG8(GET_REG8_ADDRE(0x00010b07), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b06), 0x40);
    OUTREG8(GET_REG8_ADDRE(0x00010b07), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b00), 0x01);
    OUTREG8(GET_REG8_ADDRE(0x00010b01), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b14), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b15), 0x06);
    OUTREG8(GET_REG8_ADDRE(0x00010b34), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b35), 0x00);
    OUTREG8(GET_REG8_ADDRE(0x00010b32), 0xfe);
    OUTREG8(GET_REG8_ADDRE(0x00010b33), 0x0b);

}

int do_eye (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	if(strcmp(argv[1], "hs") == 0)
	{

        USB20_verification_pattern_TSTPG();
		//while(1);
		return 0;
	}
	if(strcmp(argv[1], "fs") == 0)
	{
        USB20_verification_pattern_TSTPG_FS();
		//while(1);
		return 0;
	}
	return CMD_RET_USAGE;
}
U_BOOT_CMD(
	usb_eye, 2,	1, do_eye,
	"test eye",
	"hs  - high speed\n"
	"usb_eye fs  - full speed\n"
);
